#pragma once

enum SecureStoreErr
{
	NO_ERR                              = 0,

	WARN_CARD_CONTAINER_NAME_CHANGED    = 1,
	WARN_SPE_CANCELED_BY_USER,

	ERR_NO_MEMORY                       = 100,
	ERR_INVALID_PARAMETER,
	ERR_SCARD_FCE_FAILED,               // Winscard library error
	ERR_STM_FCE_FAILED___NOT_USED,      // Starcos library error   -   od verze SS 2.12 se STM knihovna od G&D nepouziva
	ERR_BUFFER_TOO_SMALL,
	ERR_WRONG_INPUT_DATA_LENGTH,
	ERR_OPERATION_FAILED,               // operace selhala bez blizsiho urceni chyby
	ERR_OPERATION_NOT_ALLOWED,
	ERR_PARSE_CERTIFICATE,
	ERR_SIGNATURE_INVALID,
	ERR_PIN_CACHE_EMPTY,
	ERR_PIN_CACHE_ACCESS_DENIED,        // pokud PIN z cache cte process s jinym logon ID, nez s jakym ho do cache zapsal
	ERR_PIN_CACHE_WRONG_PIN,
	ERR_READER_TYPE_UNKNOWN,
	ERR_CARD_TYPE_UNKNOWN,
	ERR_CARD_NOT_PRESENT,
	ERR_CARD_NOT_OPEN,
	ERR_CARD_DATA_INVALID,              // data na karte jsou poskozena
	ERR_CARD_OBJECT_ID_OVERFLOW,
	ERR_CARD_OBJECT_NOT_FOUND,
	ERR_CARD_NO_MEMORY,                 // nedostatek mista na karte nebo soubor je jiz plny
	ERR_CARD_ACCESS_DENIED,             // pristup k objektu/souboru na karte, ktery je chraneny auth. code (PIN, ...)
	ERR_CARD_AUTH_CODE_NOT_INITIALIZED, // auth. code (PIN, ...) neni dosud inicializovan
	ERR_CARD_AUTH_CODE_BLOCKED,         // auth. code (PIN, ...) je zablokovan
	ERR_CARD_AUTH_CODE_INVALID,         // spatne zadany auth. code (PIN, ...)
	ERR_CARD_CONTAINER_NAME_EXISTS,     // kontejner s danym nazvem jiz existuje
	ERR_CARD_CONTAINER_NOT_EMPTY,       // kontejner obsahuje jeste nejake polozky
	ERR_SPE_TIMEOUT_ELAPSED,
	ERR_ALL_ESIGN_KEY_SLOTS_OCCUPIED,   // vsechny pozice pro ESIGN klice jsou jiz obsazeny
	ERR_FILE_NOT_FOUND,                 // soubor nebyl na karte nalezen
	ERR_PATH_NOT_FOUND,                 // cesta k souboru neexistuje (= nebyl nalezen nektery z adresaru na ceste k souboru)
	ERR_OPERATION_NOT_SUPPORTED,
	ERR_NOT_IMPLEMENTED,
	ERR_PIN_POLICY_VIOLATED,            // nebyla dodrzena pravidla PINove politiky
	ERR_PIN_CHANGE_REQUIRED,            // vyzadovana zmena PINu, nebot bylo prekroceno maximalni stari PINu specifikovane v PINove politice
	ERR_CA_CERT_DISK_STORAGE_ERROR,     // nepodarilo se uspesne nacist CA certifikaty z diskoveho uloziste
	ERR_PACE_NOT_AUTHENTICATED          // nebyl proveden PACE pred volanim funkce (bezkontaktni mode)
};